import argparse
import json
import sys
import base64
from io import BytesIO
from PIL import Image
from openai import OpenAI
from qwen_agent.llm.fncall_prompts.nous_fncall_prompt import (
    NousFnCallPrompt,
    Message,
    ContentItem,
)
from qwen_vl_utils import smart_resize
import json
sys.path.append("./")
from utils.logging_utils import setup_logger_to_stdout
from utils.schema.GUI_OWL.mobile_use import MobileUse
from utils.schema.GUI_OWL.common import pil_to_base64, message_translate, parse_tags, extract_bboxes_from_brackets, draw_point, slim_messages

logger = setup_logger_to_stdout()

def parse_args(args=None, namespace=None):
    parser = argparse.ArgumentParser(description='Origin Dataset To Json')
    parser.add_argument('--dataset_name', type=str, default="AITZ",
                        help='dataset name')
    parser.add_argument('--dataset_type', type=str, default='all', help='dataset type')
    parser.add_argument('--dataset_path', type=str, default="/data3/cpz/datasets/android_in_the_zoo",
                        help='dataset path')
    parser.add_argument('--model_name', type=str, default="Agent_CPM",
                        help='model name')
    parser.add_argument('--save_path', type=str, default="/Agent_ScanKit/datasets/json",
                        help='save path')
    return parser.parse_args()

class BasePreProcess:
    def __init__(self, path, dataset_name, save_path, model_name) -> None:
        self.path = path
        self.dataset_name = dataset_name
        self.save_path = save_path
        self.model_name = model_name
    
    def readJson(self, path):
        with open(path, 'rb') as file:
            data = json.load(file)
        return data

    def saveJson(self, data, path):
        with open(path, 'w', encoding='utf-8') as file:
            json.dump(data, file, ensure_ascii=False, indent=2)

    def OS_ATLAS(self):
        sample = {
            "messages": [
                {
                    "role": "user",
                    "content": None
                },
                {
                    "role": "assistant",
                    "content": None
                }
            ],
            "images": [
                "/data3/cpz/datasets/android_in_the_zoo/test/web_shopping/WEB_SHOPPING-10013065061772250083/WEB_SHOPPING-10013065061772250083_0.png"
            ],
            "episode_id": "10013065061772250083",
            "step_id": 0
        }
        return sample
    

    def UI_TARS(self):
        SYSTEM_PROMPT = "You are a helpful assistant."
        sample = {
            "messages": [
                {
                    "role": "system",
                    "content": SYSTEM_PROMPT
                },
                {
                    "role": "user",
                    "content": [
                        {"type": "text", "text": None}
                    ],
                }
            ],
            "images": [
                "/data1/datasets/android_in_the_zoo/test/web_shopping/WEB_SHOPPING-10013065061772250083/WEB_SHOPPING-10013065061772250083_0.png"
            ],
            "episode_id": "10013065061772250083",
            "step_id": 0
        }
        return sample
    def GUI_R1(self):
        sample = {
            "messages": [
                {
                    "role": "user",
                    "content": [
                        {"type": "image", "image": ""},   
                        {"type": "text", "text": ""}      
                    ]
                }
            ],
            "images": [
                "/data1/datasets/android_in_the_zoo/test/web_shopping/WEB_SHOPPING-10013065061772250083/WEB_SHOPPING-10013065061772250083_0.png"
            ],
            "episode_id": "10013065061772250083",
            "step_id": 0
        }
        return sample

    def Agent_CPM(self):
        sample = {
            "messages": [{
                "role": "user",
                "content": [
                    f"<Question>text_prompt</Question>\n当前屏幕截图：",
                ],
            }],
            "images": [
                "/data1/datasets/android_in_the_zoo/test/web_shopping/WEB_SHOPPING-10013065061772250083/WEB_SHOPPING-10013065061772250083_0.png"
            ],
            "episode_id": "10013065061772250083",
            "step_id": 0
        }
        return sample
    
    def Aguvis(self):
        sample = {
            "messages": {
                "role": "user",
                "content": [
                    {
                        "type": "image",
                        "image": None
                    },
                    {
                        "type": "text",
                        "text": None
                    }
                ]
            },
            "images": [
                "/data3/cpz/datasets/android_in_the_zoo/test/web_shopping/WEB_SHOPPING-10013065061772250083/WEB_SHOPPING-10013065061772250083_0.png"
            ],
            "episode_id": "10013065061772250083",
            "step_id": 0
        }
        return sample
    
    def OS_Genesis(self):
        sample = {
            "question": "",
            "images": [
                "/data3/cpz/datasets/android_in_the_zoo/test/web_shopping/WEB_SHOPPING-10013065061772250083/WEB_SHOPPING-10013065061772250083_0.png"
            ],
            "episode_id": "10013065061772250083",
            "step_id": 0
        }
        return sample
    
    def GUI_Odyssey(self):
        sample = {
            "question": "Picture 1: <img>{image_path}</img>\nI'm looking for guidance on how to {instruction}",
            "episode_id": "10013065061772250083",
            "step_id": 0,
            "images": [
                "/data3/cpz/datasets/android_in_the_zoo/test/web_shopping/WEB_SHOPPING-10013065061772250083/WEB_SHOPPING-10013065061772250083_0.png"
            ],
        }
        return sample
    
    def GUI_OWL(self):
        sample = {
            "episode_id": "10013065061772250083",
            "step_id": 0,
            "images": [
                "/data3/cpz/datasets/android_in_the_zoo/test/web_shopping/WEB_SHOPPING-10013065061772250083/WEB_SHOPPING-10013065061772250083_0.png"
            ],
        }
        def build_system_messages(resized_width, resized_height):
            mobile_use = MobileUse(
                cfg={"display_width_px": resized_width, "display_height_px": resized_height}
                # TODO
            )

            query_messages = [
                Message(
                    role="system", content=[ContentItem(text="You are a helpful assistant.")]
                )
            ]

            messages = NousFnCallPrompt().preprocess_fncall_messages(
                messages=query_messages,
                functions=[mobile_use.function],
                lang=None,
            )
            messages = [m.model_dump() for m in messages]

            # messages[0]['content'][0]['type'] = 'text'
            # messages[0]['content'][1]['type'] = 'text'

            system_prompt_part = {'role': 'system', 'content': []} # TODO
            system_prompt_part['content'].append(
                {'text': messages[0]['content'][0]['text'] + messages[0]['content'][1]['text']})

            return system_prompt_part
        
        def getResizedImage(image_path):
            dummy_image = Image.open(image_path)

            MIN_PIXELS=3136
            MAX_PIXELS=10035200
            resized_height, resized_width  = smart_resize(dummy_image.height,
                dummy_image.width,
                factor=28,
                min_pixels=MIN_PIXELS,
                max_pixels=MAX_PIXELS
            )
            dummy_image = dummy_image.resize((resized_width, resized_height))
            return dummy_image

            
        def build_user_messages(instruction, enable_think=False, history=None, think_tag_begin='<thinking>', think_tag_end='</thinking>'):
            if history is None:
                history = []
            user_prompt = f'''The user query: {instruction}'''
            history = ''.join([f'Step {si+1}: {_}; 'for si, _ in enumerate(history)])
            user_prompt += f'\nTask progress (You have done the following operation on the current device): {history}.\n'
            if enable_think:
                user_prompt += f'\nBefore answering, explain your reasoning step-by-step in {think_tag_begin}{think_tag_end} tags, and insert them before the <tool_call></tool_call> XML tags.'
                user_prompt += '\nAfter answering, summarize your action in <conclusion></conclusion> tags, and insert them after the <tool_call></tool_call> XML tags.'
            user_messages = {"role": "user", "content": [{"text": user_prompt + '\n'}]}
            return user_messages
        
        return build_system_messages, getResizedImage, build_user_messages, sample
    


    
    def readImage(self, imagePath):
        from PIL import Image
        return Image.open(imagePath).convert('RGB').size
    
  
if __name__ == '__main__':
    args = parse_args()
    process = BasePreProcess(args.dataset_path, args.dataset_name, args.save_path, args.model_name)
    res = process.GUI_OWL()
    print(res)